<div class="b-tools">
    <div class="b-tools__header">
        <ul class="nav nav-tabs">
            <li class="nav-tabs-title"><span>{lang key='tools'}</span></li>
            <li><a href="#tab-saved-estates" data-toggle="tab"><span class="fa fa-star text-warning"></span></a></li>
            <li class="active"><a href="#tab-recently-viewed-properties" data-toggle="tab"><span class="fa fa-clock-o"></span></a></li>
        </ul>
    </div>
    <div class="b-tools__content">
        <div class="tab-content">
            <div class="tab-pane active" id="tab-recently-viewed-properties">
                {if $realestate.viewed}
                    <div class="ia-items recently-viewed-cars">
                        {foreach $realestate.viewed as $entry}
                            <div class="ia-item">
                                {if !empty($entry.gallery)}
                                    <a href="{$entry.link}" class="ia-item__image">{ia_image file=$entry.gallery[0] type='thumbnail' title=$entry.address|truncate:'30' width=60}</a>
                                {/if}

                                <div class="ia-item__content">
                                    <h5 class="ia-item__title">
                                        <a href="{$entry.link}">{$entry.address|escape}</a>
                                    </h5>
                                    <p><small>{$entry.address2|escape}</small></p>
                                    {if !empty($entry.price)}<p class="text-success"><span class="fa fa-tag"></span> {$entry.price_formatted}</p>{/if}
                                </div>
                            </div>
                        {/foreach}
                    </div>
                {else}
                    <div class="alert alert-info">{lang key='no_recently_viewed_properties'}</div>
                {/if}
            </div>
            <div class="tab-pane" id="tab-saved-estates">
                {if $realestate.saved}
                    <div class="ia-items saved-estates">
                        {foreach $realestate.saved as $entry}
                            <div class="ia-item">
                                {if !empty($entry.gallery)}
                                    <a href="{$entry.link}" class="ia-item__image">{ia_image file=$entry.gallery[0] type='thumbnail' title=$entry.address width=60}</a>
                                {/if}

                                <div class="ia-item__content">
                                    <h5 class="ia-item__title">
                                        <a href="{$entry.link}">{$entry.address|escape}</a>
                                    </h5>
                                    <p><small>{$entry.address2|escape}</small></p>
                                    {if !empty($entry.price)}<p class="text-success"><span class="fa fa-tag"></span> {$entry.price_formatted}</p>{/if}
                                </div>
                            </div>
                        {/foreach}
                    </div>
                {else}
                    <div class="alert alert-info">{lang key='no_saved_properties'}</div>
                {/if}
            </div>
        </div>
    </div>
</div>
