{if !empty($author)}
    <div class="ia-item-author">
        {if 'individual' == $author.registered_status}
            {$name = $author.fullname|default:$author.username}
            {$pic = $author.avatar}
        {elseif 'agency' == $author.registered_status}
            {$name = $author.company_name|default:$author.username}
            {$pic = $author.logo}
        {/if}

        <a class="ia-item-author__image" href="{ia_url type='url' item='member' data=$author}">
            {ia_image file=$pic width=120 title=$name gravatar=true email=$author.email type='thumbnail'}
        </a>
        <div class="ia-item-author__content">
            <h4 class="ia-item__title"><a href="{ia_url type='url' item='member' data=$author}">{$name|escape}</a></h4>
            <div class="ia-item__additional">
                {if 'individual' == $author.registered_status}
                    <p><span class="fa fa-user"></span> {lang key='field_member_registered_status+individual'}</p>
                {elseif 'agency' == $author.registered_status}
                    <p><span class="fa fa-briefcase"></span> {lang key='field_members_registered_status+agency'}</p>
                    {if $author.registration_number}<p><span class="fa fa-bookmark-o"></span> {lang key='field_registration_number'}: {$author.registration_number|escape}</p>{/if}
                {/if}
                {if $author.address}<p><span class="fa fa-map-pin"></span> {$author.address|escape}</p>{/if}
                {if $author.phone}<p><span class="fa fa-phone"></span> {$author.phone|escape}</p>{/if}
                {if $author.website}<p class="text-overflow"><span class="fa fa-link"></span> <a href="{$author.website|escape}">{$author.website|escape}</a></p>{/if}
                {if $author.skype}<p><span class="fa fa-skype"></span> <a href="skype:{$author.skype|escape}?call">{$author.skype|escape}</a></p>{/if}
            </div>

            <p class="text-center">
                {if !empty($author.facebook)}
                    <a href="{$author.facebook|escape:'url'}" class="fa-stack fa-lg"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-facebook fa-stack-1x fa-inverse"></i></a>
                {/if}
                {if !empty($author.twitter)}
                    <a href="{$author.twitter|escape:'url'}" class="fa-stack fa-lg"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-twitter fa-stack-1x fa-inverse"></i></a>
                {/if}
                {if !empty($author.gplus)}
                    <a href="{$author.gplus|escape:'url'}" class="fa-stack fa-lg"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-google-plus fa-stack-1x fa-inverse"></i></a>
                {/if}
                {if !empty($author.linkedin)}
                    <a href="{$author.linkedin|escape:'url'}" class="fa-stack fa-lg"><i class="fa fa-circle fa-stack-2x"></i><i class="fa fa-linkedin fa-stack-1x fa-inverse"></i></a>
                {/if}
            </p>
        </div>

        {ia_hooker name='smartyViewListingAuthorBlock'}
    </div>
{/if}