<form action="{$smarty.const.IA_URL}search/properties/" class="ia-form ia-form--search">
    <div class="row">
        <div class="col-md-2">
            <label for="as_body">{lang key='field_estate_address'}:</label>
            <input type="text" name="keyword" autocomplete="off" class="form-control" id="qs-keyword" value="{$realestate.search.defaults.keyword}">
        </div>

        <div class="col-md-2">
            <label for="re-s-category">{lang key='category'}:</label>
            <select class="form-control" name="category" id="re-s-category">
                <option value="">{lang key='any'}</option>
                {foreach $realestate.search.category as $value => $title}
                    <option value="{$value}"{if $realestate.search.defaults.category == $value} selected{/if}>{$title}</option>
                {/foreach}
            </select>
        </div>

        <div class="col-md-2">
            <label for="re-s-type">{lang key='field_estate_type'}:</label>
            <select class="form-control" name="type" id="re-s-type">
                <option value="">{lang key='any'}</option>
                {foreach $realestate.search.type as $value => $title}
                    <option value="{$value}"{if $realestate.search.defaults.type == $value} selected{/if}>{$title}</option>
                {/foreach}
            </select>
        </div>

        <div class="col-md-4">
            <label for="re-s-price-from">{lang key='field_estate_price'}:</label>
            <div class="row">
                <div class="col-md-6">
                    <input type="text" id="re-s-price-from" name="price[f]" class="form-control" maxlength="10" value="{$realestate.search.defaults.price.min}" placeholder="{lang key='from'}">
                </div>
                <div class="col-md-6">
                    <input type="text" id="re-s-price-to" name="price[t]" class="form-control" maxlength="10" value="{$realestate.search.defaults.price.max}" placeholder="{lang key='to'}">
                </div>
            </div>
        </div>

        <div class="col-md-2">
            <button type="submit" class="btn btn-primary btn-block m-t-25">{lang key='search'}</button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3">
            {if isset($realestate.search.example)}
                <p class="help-block m-t-10">
                    <span>{lang key='for_example'}</span> <a href="#" class="js-location-example">{$realestate.search.example}</a>
                </p>
            {/if}
        </div>
        <div class="col-md-offset-3 col-md-2">
            <div class="checkbox">
                <label>
                    <input type="checkbox" name="children_loc" id="re-s-child-locations" checked>
                    {lang key='include_child_locations'}
                </label>
            </div>
        </div>
        <div class="col-md-2">
            <div class="checkbox">
                <label>
                    <input type="checkbox" name="gallery" id="re-s-images" value="1"{if $realestate.search.defaults.i} checked{/if}>
                    {lang key='with_images_only'}
                </label>
            </div>
        </div>
        <div class="col-md-2">
            <p class="m-t-10">{lang key='total_houses_listed'}: <b class="text-primary">{$num_estates}</b></p>
        </div>
    </div>
</form>

{ia_add_js}
$('.js-location-example').on('click', function(e) {
    e.preventDefault();
    $('#qs-keyword').val($(this).text());
});

$('#qs-keyword').typeahead({
    source: function(query, process) {
        return $.ajax({
            url: intelli.config.url + 'realestate/address.json',
            type: 'get',
            dataType: 'json',
            data: { q: query },
            success: function(response) {
                return process(response);
            }
        });
    }
});
{/ia_add_js}
