<?php
/******************************************************************************
 *
 * Subrion Real Estate Classifieds Software
 * Copyright (C) 2018 Intelliants, LLC <https://intelliants.com>
 *
 * This file is part of Subrion Real Estate Classifieds Software.
 *
 * This program is a commercial software and any kind of using it must agree
 * to the license, see <https://subrion.pro/license.html>.
 *
 * This copyright notice may not be removed from the software source without
 * the permission of Subrion respective owners.
 *
 *
 * @link https://subrion.pro/product/real-estate.html
 *
 ******************************************************************************/

if (iaView::REQUEST_HTML != $iaView->getRequestType()) {
    return;
}

$iaCore->factory('util');
$iaEstate = $iaCore->factoryItem('estate');

$listingId = 0;

iaBreadcrumb::remove(-2);

switch ($pageAction) {
    case iaCore::ACTION_ADD:
        if (!$iaCore->get('realestate_add_guest', true) && !iaUsers::hasIdentity()) {
            return iaView::accessDenied(iaLanguage::getf('submission_is_not_allowed_for_guests',
                ['base_url' => IA_URL]));
        }

        $listing = [iaEstate::COLUMN_LOCATION => 0];

        if (1 == count($_GET)) {
            $key = key($_GET);
            if (is_numeric($key) && !$_GET[$key]) {
                if ($row = $iaEstate->getById($key, true)) {
                    $listing = $row;
                    unset($listing[iaDb::ID_COLUMN_SELECTION]);
                }
            }
        }

        break;

    case iaCore::ACTION_EDIT:
    case iaCore::ACTION_DELETE:
        if (count($iaCore->requestPath) != 1) {
            return iaView::errorPage(iaView::ERROR_NOT_FOUND);
        }

        $listingId = end($iaCore->requestPath);
        $listing = $iaEstate->getById($listingId, true);

        if (empty($listing)) {
            return iaView::errorPage(iaView::ERROR_NOT_FOUND);
        }

        if ($listing['member_id'] != iaUsers::getIdentity()->id) {
            return iaView::accessDenied(iaLanguage::get('you_have_to_be_owner_to_edit'));
        }

        if (iaCore::ACTION_DELETE == $pageAction) {
            $result = $iaEstate->delete($listingId);
            iaUtil::redirect(
                iaLanguage::get($result ? 'thanks' : 'error'),
                iaLanguage::get($result ? 'listing_successfully_removed' : 'db_error'),
                $result ? $iaEstate->url('account', []) : $iaEstate->url('view', $listing)
            );
        }

        break;

    default:
        return iaView::errorPage(iaView::ERROR_NOT_FOUND);
}

$iaField = $iaCore->factory('field');
$iaLocation = $iaCore->factoryModule('location', $iaEstate->getModuleName(), 'common');
$iaPlan = $iaCore->factory('plan');

// get available plans
$plans = $iaPlan->getPlans($iaEstate->getItemName());

if (isset($_POST['data-property'])) {
    $error = false;
    $messages = [];

    list($item, $error, $messages) = $iaField->parsePost($iaEstate->getItemName(), $listing);

    if (!iaUsers::hasIdentity() && !iaValidate::isCaptchaValid()) {
        $error = true;
        $messages[] = iaLanguage::get('confirmation_code_incorrect');
    }

    if (empty($_POST['location']) || !is_numeric($_POST['location'])) {
        $error = true;
        $messages[] = iaLanguage::get('location_is_not_set');
    } else {
        $categoryData = $iaLocation->getById((int)$_POST['location']);
        if (empty($categoryData)) {
            $error = true;
            $messages[] = iaLanguage::get('chosen_location_is_incorrect');
        } else {
            $item[iaEstate::COLUMN_LOCATION] = (int)$_POST['location'];
        }
    }

    if ($error) {
        $listing = $item;
        $listing[iaEstate::COLUMN_LOCATION] = (int)$_POST['location'];

        $iaView->setMessages($messages, iaView::ERROR);
    } else {
        $autoApprovalEnabled = $iaCore->get('realestate_auto_approval');

        if (empty($_POST['plan_id'])) {
            $item[iaEstate::COLUMN_STATUS] = $autoApprovalEnabled ? iaEstate::STATUS_AVAILABLE : iaCore::STATUS_APPROVAL;
        } elseif ($_POST['plan_id'] != $listing['sponsored_plan_id']) {
            $item[iaEstate::COLUMN_STATUS] = iaCore::STATUS_APPROVAL;
        }

        if (iaCore::ACTION_ADD == $pageAction) {
            $listingId = $iaEstate->insert($item);
            $result = (bool)$listingId;

            $resultMessage = (iaEstate::STATUS_AVAILABLE == $item[iaEstate::COLUMN_STATUS])
                ? iaLanguage::get('listing_successfully_submitted') : null;
        } else {
            if ($autoApprovalEnabled) {
                if (isset($_POST['status']) && $listing[iaEstate::COLUMN_STATUS] != iaCore::STATUS_APPROVAL) {
                    $item[iaEstate::COLUMN_STATUS] = iaSanitize::sql($_POST['status']);
                }
            } else {
                $item[iaEstate::COLUMN_STATUS] = iaCore::STATUS_APPROVAL;
            }

            $result = $iaEstate->update($item, $listingId);

            $resultMessage = iaLanguage::get('listing_successfully_updated');
        }

        $iaCore->startHook('phpAddItemAfterAll', [
            'type' => iaCore::FRONT,
            'listing' => $listingId,
            'item' => $iaEstate->getItemName(),
            'data' => $item,
            'old' => $listing
        ]);

        if ($result) {
            $iaLocation->updateCounters($item, $listing, $pageAction);

            $item = $iaEstate->getById($listingId, true);

            $url = $iaEstate->url('view', $item);

            if (!empty($_POST['plan_id']) && $_POST['plan_id'] != $item['sponsored_plan_id']) {
                $plan = $iaPlan->getById((int)$_POST['plan_id']);
                if ($plan['cost'] > 0 && $plan['id'] != $item['plan_id']) {
                    $url = $iaPlan->prePayment($iaEstate->getItemName(), $item, $plan['id'], $url);
                }
            }

            empty($resultMessage) || $iaView->setMessages($resultMessage, iaView::SUCCESS);
            iaUtil::go_to($url);
        } else {
            $iaView->setMessages(iaLanguage::get('db_error'));
        }
    }
}

$sections = $iaField->getTabs($iaEstate->getItemName(), $listing);

if (iaCore::ACTION_EDIT == $pageAction) {
    if ($listing['status'] != iaCore::STATUS_APPROVAL && $iaCore->get('realestate_auto_approval')) {
        // field emulation
        // TODO: refactor
        $sections['common'][] = [
            'collapsed' => false,
            'name' => 'status',
            'title' => iaLanguage::get('other'),
            'description' => '',
            'fields' => [
                [
                    'item' => $iaEstate->getItemName(),
                    'title' => iaLanguage::get('status'),
                    'class' => 'fieldzone',
                    'default' => $listing[iaEstate::COLUMN_STATUS],
                    'for_plan' => 0,
                    'name' => iaEstate::COLUMN_STATUS,
                    'relation' => iaField::RELATION_REGULAR,
                    'required' => true,
                    'type' => iaField::COMBO,
                    'values' => [
                        iaEstate::STATUS_AVAILABLE => iaLanguage::get(iaEstate::STATUS_AVAILABLE),
                        iaEstate::STATUS_HIDDEN => iaLanguage::get(iaEstate::STATUS_HIDDEN),
                        iaEstate::STATUS_SOLD => iaLanguage::get(iaEstate::STATUS_SOLD),
                        iaEstate::STATUS_RENTED => iaLanguage::get(iaEstate::STATUS_RENTED)
                    ]
                ]
            ]
        ];
    }
}

$listing['parents'] = $iaLocation->getParentsFlat($listing[iaEstate::COLUMN_LOCATION]);

$iaView->assign('item', $listing);
$iaView->assign('locations', $iaLocation->getChildrenList([]));
$iaView->assign('plans', $plans);
$iaView->assign('sections', $sections);

$iaView->display('manage');
