intelli.estatesMap = {
    init: function () {
        intelli.marker = null;

        var map = new google.maps.Map(document.getElementById('re-gmap'), {
            mapTypeId: google.maps.MapTypeId.HYBRID,
            zoom: 11
        });
        var fullAddress = $('#js-full-address').val();
        var geoCoder = new google.maps.Geocoder();

        geoCoder.geocode({address: fullAddress}, function (result, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                intelli.marker = new google.maps.Marker(
                    {
                        icon: intelli.config.packages.realestate.tpl_url + 'front/img/i-marker.png',
                        map: map,
                        position: result[0].geometry.location,
                        title: fullAddress
                    });

                map.setCenter(result[0].geometry.location);

                google.maps.event.addListener(intelli.marker, 'click', function () {
                    map.setZoom(map.getZoom() == 11 ? 18 : 11);
                    map.setCenter(result[0].geometry.location);
                });
            }
            else {
                $('#re-gmap').css('display', 'table-cell').text(_t('unable_to_get_coordinates'));
            }

            /* This is a fix for misaligned google map */
            if ($('#tab-fieldgroup_estate_location').length > 0 && result[0]) {
                $('a[href="#tab-fieldgroup_estate_location"]').on('shown', function () {
                    google.maps.event.trigger(map, 'resize');
                    map.setCenter(result[0].geometry.location);
                });
            }
        });
    },
    loadGoogleMaps: function loadScript(path, handler) {
        var tag = document.createElement('script');

        tag.type = 'text/javascript';
        tag.src = path;
        tag.onreadystatechange = function () {
            if (this.readyState == 'complete' || this.readyState == 'loaded') this.onload({target: this});
        };
        tag.onload = handler;

        document.getElementsByTagName('head')[0].appendChild(tag);
    }
}

$(function () {
    if ($('#re-gmap').length) {
        $('#address_fieldzone').html('<strong>' + $('#js-full-address').val() + '</strong>');

        if ($('.js-gmap').length) {
            $(document).on('mapsLoaded', function () {
                intelli.estatesMap.init();
            });
        } else {
            if (typeof google === 'object' && typeof google.maps === 'object') {
                intelli.estatesMap.init();
            } else {
                intelli.estatesMap.loadGoogleMaps('//maps.googleapis.com/maps/api/js?key=' + intelli.config.maps_api_key + '&callback=intelli.estatesMap.init');
            }
        }

        $('#re-gmap').css('visibility', 'visible');
    }
});