intelli.comparison = {
    url: intelli.config.packages.realestate.url + 'comparison.json',

    controller: function (e) {
        e.preventDefault();

        if ($(this).hasClass('btn-compare--added')) {
            intelli.comparison.remove($(this));
        }
        else {
            intelli.comparison.add($(this));
        }
    },
    add: function ($this) {
        $.getJSON(intelli.comparison.url + '?action=add&id=' + $this.data('id'), intelli.comparison.output);

        $this.addClass('btn-compare--added');
        $this.find('.btn-compare__text').text(_t('remove_from_compare'));

        intelli.notifFloatBox({msg: _t('comparison_added'), type: 'notif', autohide: true});
    },
    remove: function ($this) {
        $.getJSON(intelli.comparison.url + '?action=delete&id=' + $this.data('id'), intelli.comparison.output);

        if (!$('body').hasClass('page-realestate_comparison')) {
            $this.removeClass('btn-compare--added');
            $this.find('.btn-compare__text').text(_t('mark_to_compare'));

            intelli.notifFloatBox({msg: _t('comparison_deleted'), type: 'notif', autohide: true});
        }
    },
    removelisting: function (e) {
        e.preventDefault();

        $.getJSON(intelli.comparison.url + '?action=delete&id=' + $(this).data('id'), intelli.comparison.output);
        $('.btn-compare[data-id=' + $(this).data('id') + ']').removeClass('btn-compare--added');
        $('.btn-compare[data-id=' + $(this).data('id') + ']').find('.btn-compare__text').text(_t('mark_to_compare'));
        intelli.notifFloatBox({msg: _t('comparison_deleted'), type: 'notif', autohide: true});
    },
    update: function () {
        $.getJSON(intelli.comparison.url + '?action=get', intelli.comparison.output);
    },
    output: function (response) {
        if (response) {
            var items = [];
            $.each(response.listings, function (id, title) {
                if (title) {
                    if (id.length < 7) {
                        id = "0".repeat(7 - id.length) + id;
                    }
                    items.push('<div class="box-compare__item clearfix">' + title + ' <a class="btn btn-xs pull-right" href="#" data-id="'
                        + id + '" title="' + _t('delete') + '"><span class="fa fa-times"></span></a></div>');
                }
            });
            $('#comparison-list').html(items.length ? items.join('') : _t('no_listings_selected_to_compare')).find('div:last').css('opacity', 0).animate({opacity: 1}, 'slow');
        }
        $('.box-compare__item', '#comparison-list').length > 1
            ? $('#js-cmd-compare').show()
            : $('#js-cmd-compare').hide();
    }

};

$(function () {
    $('.btn-compare').click(intelli.comparison.controller);
    $('#comparison-list').on('click', 'a', intelli.comparison.removelisting);
    intelli.comparison.update();
});