intelli.locations = {
    url: intelli.config.packages.realestate.url,
    requestUrl: intelli.config.admin_url + '/realestate/locations/',

    triggerAlias: function () {
        var $urlPreview = $('#js-url-preview');

        $urlPreview.text(intelli.locations.url);

        if ($(this).val()) {
            var loadingIcon = $('<img>').attr({src: intelli.config.ia_url + 'templates/_common/img/preloader.gif'}).insertAfter(this);
            $.getJSON(intelli.locations.requestUrl + 'alias.json', {title: $(this).val()}, function (response) {
                var alias = response.alias;
                $('#input-alias').val(alias);
                if (alias != '') {
                    $urlPreview.text($urlPreview.text() + alias + '/');
                }
                loadingIcon.remove();
            });
        }
    },

    triggerUrl: function () {
        $.getJSON(intelli.locations.requestUrl + 'url.json', {pid: $('#input-location').val()}, function (response) {
            intelli.locations.url = response.url;
            $('#input-alias').trigger('blur');
        });
    }
};

$(function () {
    $('select.js-iad').iaDropdown(
        {
            exclusions: true,
            label: 'js-location-label',
            url: intelli.locations.url + 'locations.json',
            valueHolder: 'parent'
        });

    $('#input-alias, #field_location_title').on('blur', intelli.locations.triggerAlias);
    $('div.js-selectboxes-group').on('change', 'select.js-iad', intelli.locations.triggerUrl);
});