Ext.onReady(function () {
    var params = $('#js-location-params').data();

    var grid = new IntelliGrid(
        {
            columns: [
                'selection',
                {name: 'address', title: _t('address'), width: 2},
                {name: 'type', title: _t('type'), width: 140},
                {name: 'id', title: _t('id'), width: 95},
                {name: 'date_added', title: _t('date'), width: 100, editor: 'date'},
                'status',
                'update',
                'delete'
            ],
            statuses: ['available', 'hidden', 'sold', 'approval'],
            storeParams: {location_id: params.location},
            texts: {
                delete_multiple: _t('do_you_want_to_delete_selected_listings'),
                delete_single: _t('do_you_want_to_delete_this_listing')
            },
            title: params.title + ' ' + _t('listings'),
            url: intelli.config.admin_url + '/realestate/properties/'
        }, false);

    grid.toolbar = new Ext.Toolbar({
        items: [
            {
                emptyText: _t('address'),
                name: 'address',
                listeners: intelli.gridHelper.listener.specialKey,
                width: 180,
                xtype: 'textfield'
            }, {
                displayField: 'title',
                editable: false,
                emptyText: _t('type'),
                id: 'fltTitle',
                name: 'type',
                store: intelli.gridHelper.store.ajax(grid.url + 'types.json'),
                typeAhead: true,
                valueField: 'value',
                width: 140,
                xtype: 'combo'
            }, {
                emptyText: _t('id'),
                name: 'id',
                maxLength: 8,
                width: 85,
                xtype: 'textfield',
                listeners: intelli.gridHelper.listener.specialKey
            }, {
                editable: false,
                emptyText: _t('category'),
                name: 'category',
                store: ['sale', 'rent'],
                typeAhead: true,
                width: 80,
                xtype: 'combo'
            }, {
                displayField: 'title',
                editable: false,
                emptyText: _t('status'),
                name: 'status',
                store: grid.stores.statuses,
                typeAhead: true,
                valueField: 'value',
                xtype: 'combo'
            }, {
                handler: function () {
                    intelli.gridHelper.search(grid);
                },
                id: 'fltBtn',
                text: '<i class="i-search"></i> ' + _t('search')
            }, {
                handler: function () {
                    intelli.gridHelper.search(grid, true);
                },
                text: '<i class="i-close"></i> ' + _t('reset')
            }]
    });

    grid.init();
});