<?php
/******************************************************************************
 *
 * Subrion Real Estate Classifieds Software
 * Copyright (C) 2018 Intelliants, LLC <https://intelliants.com>
 *
 * This file is part of Subrion Real Estate Classifieds Software.
 *
 * This program is a commercial software and any kind of using it must agree
 * to the license, see <https://subrion.pro/license.html>.
 *
 * This copyright notice may not be removed from the software source without
 * the permission of Subrion respective owners.
 *
 *
 * @link https://subrion.pro/product/real-estate.html
 *
 ******************************************************************************/

if (iaView::REQUEST_JSON == $iaView->getRequestType()) {
    if (isset($_GET['pid']) && is_numeric($_GET['pid'])) {
        $iaView->jsonp($iaCore->factoryModule('location', IA_CURRENT_MODULE, 'common')->getChildrenList($_GET));
        // TODO: in order to prevent loading of empty end-level categories it is needed to add a flag to indicate that there is no children
    }

    if ('realestate_locations' == $iaView->name()) {
        $iaLocation = $iaCore->factoryModule('location', IA_CURRENT_MODULE, 'common');

        $output = [];

        if (isset($_GET['id']) && is_numeric($_GET['id'])) {
            if ($locations = $iaLocation->getChildren($_GET['id'])) {
                foreach ($locations as $location) {
                    $output[] = ['id' => $location['id'], 'text' => $location['title']];
                }
            }
        }

        $iaView->assign($output);
    }

    if (count($iaCore->requestPath) > 0) {
        $output = [];

        switch ($iaCore->requestPath[0]) {
            case 'callback-request':
                $error = true;
                $messages = [];

                $memberInfo = $iaCore->factory('users')->getInfo((int)$_POST['author']);
                if (empty($memberInfo) || $memberInfo['status'] != iaCore::STATUS_ACTIVE) {
                    $messages[] = iaLanguage::get('member_doesnt_exist');
                }

                if (!iaValidate::isCaptchaValid()) {
                    $messages[] = iaLanguage::get('confirmation_code_incorrect');
                }

                if (!$messages) {
                    foreach (['best_time', 'phone'] as $fieldName) {
                        if (empty($_POST[$fieldName])) {
                            $messages[] = iaLanguage::getf('field_is_empty', ['field' => iaLanguage::get($fieldName)]);
                        }
                    }

                    if (!$messages) {
                        $iaMailer = $iaCore->factory('mailer');

                        if ($iaMailer->loadTemplate('realestate_callback_request')) {
                            $iaMailer->addAddress($memberInfo['email'], $memberInfo['fullname']);

                            $iaMailer->setReplacements([
                                'fullname' => $memberInfo['fullname'],
                                'bestTime' => iaSanitize::tags($_POST['best_time']),
                                'phone' => iaSanitize::tags($_POST['phone']),
                                'comment' => iaSanitize::tags($_POST['comment'])
                            ]);

                            $iaMailer->setSubject(str_replace(':title', iaSanitize::tags($_POST['title']),
                                $iaMailer->Subject));
                        }

                        $error = !$iaMailer->send();
                        $messages[] = iaLanguage::get($error ? 'unable_to_send_email' : 'mail_sent');
                    }
                }

                $output['error'] = $error;
                $output['message'] = $messages;

                break;

            case 'address':
                if ($locations = $iaCore->factoryModule('location', IA_CURRENT_MODULE, 'common')->search([
                    [
                        'column' => iaLocation::COLUMN_TITLE,
                        'cond' => iaLocation::SQL_CONDITION_LIKE,
                        'value' => iaSanitize::sql($_GET['q'])
                    ]
                ],
                    [iaLocation::COLUMN_TITLE, iaLocation::FAKE_COLUMN_ABBREVIATION],
                    ['field' => iaLocation::COLUMN_TITLE, 'direction' => 'ASC'],
                    0,
                    isset($_GET['limit']) && is_numeric($_GET['limit']) ? (int)$_GET['limit'] : 8)
                ) {
                    foreach ($locations as $item) {
                        $output[] = $item[iaLocation::COLUMN_TITLE] . ($item[iaLocation::FAKE_COLUMN_ABBREVIATION] ? ', ' . $item[iaLocation::FAKE_COLUMN_ABBREVIATION] : '');
                    }
                }
        }

        $iaView->assign($output);
    }
}

if (iaView::REQUEST_HTML == $iaView->getRequestType()) {
    $pagination = [
        'limit' => $iaCore->get('realestate_num_per_page', 10),
        'start' => 0,
        'total' => 0,
        'url' => IA_SELF . '?page={page}'
    ];

    $page = isset($_GET['page']) && is_numeric($_GET['page']) ? max((int)$_GET['page'], 1) : 1;
    $pagination['start'] = ($page - 1) * $pagination['limit'];

    $title = $iaView->title();
    $pageActions = [];
    $filtersParams = [];

    $iaField = $iaCore->factory('field');
    $iaEstate = $iaCore->factoryItem('estate');
    $iaLocation = $iaCore->factoryModule('location', IA_CURRENT_MODULE, 'common');

    $_SESSION[iaEstate::SESSION_SORTING_KEY] = $iaEstate->sortingParams($_GET, $_SESSION);

    if ($iaAcl->isAccessible('realestate_add', iaCore::ACTION_ADD)) {
        $pageActions[] = [
            'icon' => 'plus-square',
            'title' => iaLanguage::get('page_title_realestate_add'),
            'url' => IA_MODULE_URL . 'add/',
            'classes' => 'btn-success'
        ];
    }

    switch ($iaView->name()) {
        case 'realestate_index':
            if (empty($iaCore->requestPath)) {
                $iaCore->set('isSubCategory', false);

                $listings = $iaEstate->get([], $pagination['start'], $pagination['limit'],
                    $_SESSION[iaEstate::SESSION_SORTING_KEY]);

                $rssFeed = (IA_MODULE_URL == IA_URL)
                    ? IA_URL . $iaEstate->getModuleName()
                    : rtrim(IA_MODULE_URL, IA_URL_DELIMITER);
                $rssFeed .= '.' . iaCore::EXTENSION_XML;
            } else {
                $location = $iaLocation->getByUrl($iaCore->requestPath);
                if (empty($location)) {
                    return iaView::errorPage(iaView::ERROR_NOT_FOUND);
                }

                $iaCore->set('isSubCategory', true);

                $filters = [];
                $parents = $iaLocation->getParents($location['id']);
                foreach ($parents as $key => $item) {
                    isset($parents[$key + 1])
                        ? iaBreadcrumb::add($item['title'], IA_MODULE_URL . $item['url'])
                        : iaBreadcrumb::replaceEnd($item['title']);
                    (0 === $key || 1 === $key) && $filters[0 == $key ? 'l' : 'sl'] = $item['id'];
                }

                $title = $location['title'];

                $iaView->assign('locations',
                    $iaLocation->getChildren($location['id'], $iaCore->get('realestate_hide_empty_locations')));

                $stmt = $iaCore->get('realestate_show_sublocation_properties')
                    ? iaDb::printf('t.`left` >= :left AND t.`right` <= :right', $location)
                    : [iaEstate::COLUMN_LOCATION => $location['id']];

                $listings = $iaEstate->get($stmt, $pagination['start'], $pagination['limit'],
                    $_SESSION[iaEstate::SESSION_SORTING_KEY]);

                $iaView->set('filtersItemName', $iaEstate->getItemName());
                $iaView->set('filtersParams', $filters);

                if (isset($location['meta_description']) && $location['meta_description']) {
                    $iaView->set('description', $location['meta_description']);
                }
                if (isset($location['meta_keywords']) && $location['meta_keywords']) {
                    $iaView->set('keywords', $location['meta_keywords']);
                }

                $rssFeed = substr_replace(IA_SELF, '.' . iaCore::EXTENSION_XML, -1);
            }

            break;

        case 'realestate_index_featured':
            $listings = $iaEstate->get(['featured' => 1], $pagination['start'], $pagination['limit'],
                $_SESSION[iaEstate::SESSION_SORTING_KEY], true);

            $rssFeed = substr_replace(IA_SELF, '.' . iaCore::EXTENSION_XML, -1);

            break;

        case 'realestate_index_sponsored':
            $listings = $iaEstate->get(['sponsored' => 1], $pagination['start'], $pagination['limit'],
                $_SESSION[iaEstate::SESSION_SORTING_KEY], true);

            $rssFeed = substr_replace(IA_SELF, '.' . iaCore::EXTENSION_XML, -1);

            break;

        case 'realestate_index_my':
            if (!iaUsers::hasIdentity()) {
                return iaView::accessDenied();
            }

            $listings = $iaEstate->get(['member_id' => iaUsers::getIdentity()->id], $pagination['start'],
                $pagination['limit'], $_SESSION[iaEstate::SESSION_SORTING_KEY], true);

            $rssFeed = substr_replace(IA_SELF, '.' . iaCore::EXTENSION_XML, -1);

            break;

        default:
            return iaView::errorPage(iaView::ERROR_NOT_FOUND);
    }

    if (isset($listings)) {
        $pagination['total'] = $iaEstate->getFoundRows();

        if ($listings) {
            $iaItem = $iaCore->factory('item');
            $listings = $iaItem->updateItemsFavorites($listings, $iaEstate->getItemName());
        }

        $iaView->assign('listings', $listings);
        $iaView->assign('pagination', $pagination);
        $iaView->assign('sorting', $_SESSION[iaEstate::SESSION_SORTING_KEY]);
    }

    if (isset($location)) {
        $iaView->assign('location', $location);
    }

    $pageActions[] = [
        'icon' => 'rss',
        'title' => '',
        'url' => $rssFeed,
        'classes' => 'btn-warning'
    ];

    $iaView->set('actions', $pageActions);
    $iaView->set('filtersItemName', $iaEstate->getItemName());
    $iaView->set('filtersParams', $filtersParams);

    $iaView->title($title);

    $iaView->display('index');
}

if (iaView::REQUEST_XML == $iaView->getRequestType()) {
    $iaEstate = $iaCore->factoryItem('estate');

    $output = [
        'title' => $iaCore->get('site') . ' :: ' . $iaView->title(),
        'description' => '',
        'url' => '',
        'item' => []
    ];

    switch ($iaView->name()) {
        default:
            if (empty($iaCore->requestPath)) {
                $listings = $iaEstate->get(null, 0, (int)$iaCore->get('realestate_rss_entries', 20),
                    ['field' => 'date_modified', 'direction' => 'DESC']);
                $output['url'] = IA_MODULE_URL;
            } else {
                $iaLocation = $iaCore->factoryModule('location', IA_CURRENT_MODULE, 'common');

                $location = $iaLocation->getByUrl($iaCore->requestPath);
                $listings = $iaEstate->get([iaEstate::COLUMN_LOCATION => $location['id']], 0,
                    (int)$iaCore->get('realestate_rss_entries', 20),
                    ['field' => 'date_modified', 'direction' => 'DESC']);
                $output['url'] = IA_URL . $location['url'];
            }

            break;

        case 'realestate_index_featured':
            $listings = $iaEstate->get(['featured' => 1], 0, (int)$iaCore->get('realestate_rss_entries', 20),
                ['field' => 'date_modified', 'direction' => 'DESC']);
            $output['url'] = IA_MODULE_URL . 'featured/';

            break;

        case 'realestate_index_sponsored':
            $listings = $iaEstate->get(['sponsored' => 1], 0, (int)$iaCore->get('realestate_rss_entries', 20),
                ['field' => 'date_modified', 'direction' => 'DESC']);
            $output['url'] = IA_MODULE_URL . 'sponsored/';

            break;

        case 'realestate_index_my':
            $listings = $iaEstate->get(['member_id' => iaUsers::getIdentity()->id], 0,
                (int)$iaCore->get('realestate_rss_entries', 20), ['field' => 'date_modified', 'direction' => 'DESC']);
            $output['url'] = IA_URL . 'profile/properties/';
    }

    foreach ($listings as $entry) {
        $url = $iaEstate->url('view', $entry);

        $output['item'][] = [
            'title' => iaLanguage::get('field_type_' . $entry['type']) . ': ' . $entry['title'],
            'guid' => $url,
            'link' => $url,
            'pubDate' => date('D, d M Y H:i:s T', strtotime($entry['date_modified'])),
            'description' => iaDb::printf(':address, :state :zipcode :location', $entry),
            'category' => iaLanguage::get('field_category_' . $entry['category'])
        ];
    }

    $iaView->assign('channel', $output);
}
