<?php
/******************************************************************************
 *
 * Subrion Real Estate Classifieds Software
 * Copyright (C) 2018 Intelliants, LLC <https://intelliants.com>
 *
 * This file is part of Subrion Real Estate Classifieds Software.
 *
 * This program is a commercial software and any kind of using it must agree
 * to the license, see <https://subrion.pro/license.html>.
 *
 * This copyright notice may not be removed from the software source without
 * the permission of Subrion respective owners.
 *
 *
 * @link https://subrion.pro/product/real-estate.html
 *
 ******************************************************************************/

if ($iaCore->get('default_package') == 'realestate' || !$iaCore->checkDomain()) {
    if ($iaView->url) {
        $alias = implode(IA_URL_DELIMITER, $iaView->url) . IA_URL_DELIMITER;
        if ($iaDb->exists('`url` = :url AND `status` = :status', ['url' => $alias, 'status' => iaCore::STATUS_ACTIVE], 'locations')) {
            if ($pageUrl = $iaDb->one_bind('alias', '`name` = :page AND `status` = :status',
                ['page' => 'realestate_index', 'status' => iaCore::STATUS_ACTIVE], 'pages')
            ) {
                $pageUrl = explode(IA_URL_DELIMITER, trim($pageUrl, IA_URL_DELIMITER));
                $pageUrl = array_shift($pageUrl);
                $pageUrl = ('realestate_index' == $iaCore->get('home_page')) ? $pageUrl . '_index' : $pageUrl;

                $iaView->name($pageUrl);
                $iaCore->requestPath = $iaView->url;
            }
        }
    }
}
