<?php
/******************************************************************************
 *
 * Subrion Real Estate Classifieds Software
 * Copyright (C) 2018 Intelliants, LLC <https://intelliants.com>
 *
 * This file is part of Subrion Real Estate Classifieds Software.
 *
 * This program is a commercial software and any kind of using it must agree
 * to the license, see <https://subrion.pro/license.html>.
 *
 * This copyright notice may not be removed from the software source without
 * the permission of Subrion respective owners.
 *
 *
 * @link https://subrion.pro/product/real-estate.html
 *
 ******************************************************************************/

class iaAgent extends abstractCore
{


    public function getTopAgents($limit)
    {
        $this->iaCore->factoryItem('estate');

        $sql = <<<SQL
SELECT *, (SELECT COUNT(*) FROM `:table_properties` WHERE `member_id` = m.`id`) `count` 
  FROM `:table_members` m 
WHERE m.`status` = ':status' AND m.`registered_status` != '' 
  HAVING `count` > 0 
ORDER BY `count` DESC 
LIMIT :limit
SQL;
        $sql = iaDb::printf($sql, [
            'table_properties' => iaEstate::getTable(true),
            'table_members' => iaUsers::getTable(true),
            'status' => iaCore::STATUS_ACTIVE,
            'limit' => (int)$limit,
        ]);

        $result = $this->iaDb->getAll($sql);
        if ($result && is_array($result)) {
            foreach ($result as &$item) {
                $item['avatar'] = empty($item['avatar']) ? $item['avatar'] : unserialize($item['avatar']);
            }
        }

        return $result;
    }
}
