<?php
/******************************************************************************
 *
 * Subrion Real Estate Classifieds Software
 * Copyright (C) 2018 Intelliants, LLC <https://intelliants.com>
 *
 * This file is part of Subrion Real Estate Classifieds Software.
 *
 * This program is a commercial software and any kind of using it must agree
 * to the license, see <https://subrion.pro/license.html>.
 *
 * This copyright notice may not be removed from the software source without
 * the permission of Subrion respective owners.
 *
 *
 * @link https://subrion.pro/product/real-estate.html
 *
 ******************************************************************************/

class iaBackendController extends iaAbstractControllerModuleBackend
{
    protected $_name = 'locations';

    protected $_gridColumns = ['id', 'url', 'title', 'count' => 'num_listings', 'order', 'status'];
    protected $_gridFilters = ['title' => self::LIKE, 'status' => self::EQUAL];

    protected $_activityLog = ['item' => 'location'];


    public function __construct()
    {
        parent::__construct();

        $helperClass = $this->_iaCore->factoryModule('location', $this->getModuleName(), 'common');
        $this->setHelper($helperClass);

        $this->_setItemName($helperClass->getItemName());

        $this->_path = IA_ADMIN_URL . $this->getModuleName() . IA_URL_DELIMITER . $this->getName() . IA_URL_DELIMITER;
        $this->_template = 'form-' . $this->getName();

        $this->_iaDb->setTable($helperClass::getTable());
    }

    public function getById($id)
    {
        return $this->getHelper()->getById($id);
    }

    protected function _indexPage(&$iaView)
    {
        ('foldered' == $this->_iaCore->get('realestate_locations_browse_type'))
            ? $this->_folderView($iaView)
            : parent::_indexPage($iaView);
    }

    protected function _setPageTitle(&$iaView, array $entryData, $action)
    {
        (iaCore::ACTION_EDIT == $action)
            ? $iaView->title(iaLanguage::getf('edit_location', ['location' => $entryData['title']]))
            : parent::_setPageTitle($iaView, $entryData, $action);
    }

    protected function _gridRead($params)
    {
        $action = empty($this->_iaCore->requestPath[0]) ? null : $this->_iaCore->requestPath[0];

        switch ($action) {
            default:
                return parent::_gridRead($params);
            case 'alias':
                return ['alias' => iaSanitize::alias($params['title'])];
            case 'url':
                return ['url' => $this->_getJsonUrl($params)];
        }
    }

    protected function _gridModifyOutput(array &$entries)
    {
        foreach ($entries as &$entry) {
            if (1 == $entry['id']) {
                $entry['update'] = $entry['delete'] = 0;
            }
        }
    }

    protected function _insert(array $entryData)
    {
        return $this->getHelper()->insert($entryData);
    }

    protected function _update(array $entryData, $id)
    {
        return $this->getHelper()->update($entryData, $id);
    }

    protected function _delete($entryId)
    {
        return $this->getHelper()->delete($entryId);
    }

    protected function _setDefaultValues(array &$entry)
    {
        $entry = [
            'parent' => iaLocation::ID_ROOT,
            'url' => '',
            'status' => iaCore::STATUS_ACTIVE,
            'alias' => '',
            'locked' => false,
            'title' => ''
        ];
    }

    protected function _preSaveEntry(array &$entry, array $data, $action)
    {
        parent::_preSaveEntry($entry, $data, $action);

        $entry['parent'] = (int)$data['parent'];

        if (!$entry['parent']) {
            $parentCategory = ['url' => ''];
        } else {
            $parentCategory = $this->getHelper()->getById($entry[iaLocation::NS_PARENT]);

            if (empty($parentCategory)) {
                $this->addMessage('parent_category_is_invalid');
            }
        }

        $entry['alias'] = $data['alias'];
        $entry['url'] = $parentCategory['url'];

        if (empty($entry['alias'])) {
            $this->addMessage('alias_is_empty');
        } else {
            $entry['url'] .= trim($entry['alias'], IA_URL_DELIMITER) . IA_URL_DELIMITER;
        }

        return !$this->getMessages();
    }

    protected function _assignValues(&$iaView, array &$entryData)
    {
        parent::_assignValues($iaView, $entryData);

        $entryData['parents'] = $this->getHelper()->getParentsFlat($entryData['parent']);

        $children = $this->getHelper()->getChildrenList(['id' => $this->getEntryId()]);

        $iaView->assign('categories', $children);
        $iaView->assign('statuses', $this->getHelper()->getStatuses());
    }


    private function _folderView(&$iaView)
    {
        $rootLocation = $this->getHelper()->getById(iaLocation::ID_ROOT);
        $location = $this->getHelper()->getByUrl($this->_iaCore->requestPath);

        if ($this->_iaCore->requestPath && empty($location)) {
            return iaView::errorPage(iaView::ERROR_NOT_FOUND);
        }

        empty($this->_iaCore->requestPath)
            ? iaBreadcrumb::replaceEnd($rootLocation['title'], $this->getPath())
            : iaBreadcrumb::add($rootLocation['title'], $this->getPath());

        if (empty($this->_iaCore->requestPath)) {
            $title = $location['title'];
        } else {
            $title = '';

            if ($parents = $this->getHelper()->getParents($location[iaLocation::COLUMN_ID])) {
                foreach ($parents as $i => $level) {
                    $title .= $level['title'];
                    if (isset($parents[$i + 1])) {
                        $title .= ' &raquo; ';
                        iaBreadcrumb::add($level['title'], $this->getPath() . $level['url']);
                    } else {
                        iaBreadcrumb::replaceEnd($level['title'], $this->getPath() . $level['url']);
                    }
                }
            }
        }

        $iaView->assign('title', $title);
        $iaView->assign('base_url', $this->getPath());
        $iaView->assign('location', $location);
        $iaView->assign('children',
            $this->getHelper()->getChildren(empty($this->_iaCore->requestPath) ? $rootLocation['id'] : $location['id']));

        $iaView->grid();
        $iaView->display('locations');
    }

    private function _getJsonUrl(array $params)
    {
        $url = IA_MODULE_URL;

        if (isset($params['pid']) && is_numeric($params['pid'])) {
            if ($parentData = $this->getHelper()->getById((int)$params['pid'])) {
                $url .= $parentData['url'];
            }
        }

        return $url;
    }
}